/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileSnowball;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class ItemSnowball
extends Item
implements IDispensable {
    public ItemSnowball(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        itemstack.consumeItem(entityplayer);
        world.playSoundAtEntity(entityplayer, entityplayer, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            world.entityJoinedWorld(new ProjectileSnowball(world, entityplayer));
        }
        return itemstack;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        ProjectileSnowball projectileSnowball = new ProjectileSnowball(world, (double)blockX + offX, (double)blockY + offY, (double)blockZ + offZ);
        projectileSnowball.setHeading((double)direction.getOffsetX() * 0.6, direction.getOffsetY() == 0 ? 0.1 : (double)direction.getOffsetY() * 0.6, (float)direction.getOffsetZ() * 0.6f, 1.1f, 6.0f);
        world.entityJoinedWorld(projectileSnowball);
        --itemStack.stackSize;
    }

    @Override
    public void onDispensed(ItemStack itemStack, World world, double x, double y, double z, int xOffset, int yOffset, int zOffset, Random random) {
        ProjectileSnowball entitysnowball = new ProjectileSnowball(world, x, y, z);
        entitysnowball.setHeading(xOffset, (double)yOffset + 0.1, zOffset, 1.1f, 6.0f);
        world.entityJoinedWorld(entitysnowball);
    }
}

