/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentTypeString;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.server.entity.player.PlayerServer;

public class CommandNickname
implements CommandManager.CommandRegistry {
    private static final SimpleCommandExceptionType NICKNAME_TOO_LARGE = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.nickname.exception_too_large"));
    private static final SimpleCommandExceptionType NICKNAME_TOO_SMALL = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.nickname.exception_too_small"));

    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode<CommandSource> command = dispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("nickname").then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("set").then(((ArgumentBuilderRequired)ArgumentBuilderRequired.argument("target", ArgumentTypeEntity.username()).requires(CommandSource::hasAdmin)).then(ArgumentBuilderRequired.argument("nickname", ArgumentTypeString.string()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            String nickname = c.getArgument("nickname", String.class);
            if (nickname.length() > 16) {
                throw NICKNAME_TOO_LARGE.create();
            }
            if (nickname.isEmpty()) {
                throw NICKNAME_TOO_SMALL.create();
            }
            List<? extends Entity> entities = entitySelector.get(source);
            PlayerServer player = (PlayerServer)entities.get(0);
            player.nickname = nickname;
            player.hadNicknameSet = true;
            player.mcServer.playerList.updatePlayerProfile(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator());
            if (source.getSender() == player) {
                source.sendTranslatableMessage("command.commands.nickname.set.success", nickname);
            } else {
                source.sendTranslatableMessage("command.commands.nickname.set.success_other", player.username, nickname);
                source.sendTranslatableMessage(player, "command.commands.nickname.set.success_receiver", nickname);
            }
            return 1;
        })))).then(ArgumentBuilderRequired.argument("nickname", ArgumentTypeString.string()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            String nickname = c.getArgument("nickname", String.class);
            if (nickname.length() > 16) {
                throw NICKNAME_TOO_LARGE.create();
            }
            if (nickname.isEmpty()) {
                throw NICKNAME_TOO_SMALL.create();
            }
            PlayerServer player = (PlayerServer)source.getSender();
            if (player == null) {
                throw CommandExceptions.notInWorld().create();
            }
            player.nickname = nickname;
            player.hadNicknameSet = true;
            player.mcServer.playerList.updatePlayerProfile(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator());
            source.sendTranslatableMessage("command.commands.nickname.set.success", nickname);
            return 1;
        })))).then(ArgumentBuilderLiteral.literal("get").then(ArgumentBuilderRequired.argument("target", ArgumentTypeEntity.username()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            PlayerServer player = (PlayerServer)entities.get(0);
            source.sendTranslatableMessage("command.commands.nickname.get.success", player.username, player.nickname);
            return 1;
        })))).then(((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("reset").then(((ArgumentBuilderRequired)ArgumentBuilderRequired.argument("target", ArgumentTypeEntity.username()).requires(CommandSource::hasAdmin)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            PlayerServer player = (PlayerServer)entities.get(0);
            player.nickname = "";
            player.hadNicknameSet = false;
            player.mcServer.playerList.updatePlayerProfile(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator());
            if (source.getSender() == player) {
                source.sendTranslatableMessage("command.commands.nickname.reset.success", new Object[0]);
            } else {
                source.sendTranslatableMessage("command.commands.nickname.reset.success_other", player.username);
                source.sendTranslatableMessage(player, "command.commands.nickname.reset.success_receiver", new Object[0]);
            }
            return 1;
        }))).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            PlayerServer player = (PlayerServer)source.getSender();
            if (player == null) {
                throw CommandExceptions.notInWorld().create();
            }
            player.nickname = "";
            player.hadNicknameSet = false;
            player.mcServer.playerList.updatePlayerProfile(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator());
            source.sendTranslatableMessage("command.commands.nickname.reset.success", player.username);
            return 1;
        })));
        dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("nick").redirect(command));
    }
}

