/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save.conversion;

import com.mojang.nbt.tags.CompoundTag;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.save.ISaveConverter;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.SaveFormats;

public abstract class SaveConverterMCRegionBase
implements ISaveConverter {
    File savesDir;
    String worldDirName;

    /*
     * WARNING - void declaration
     */
    @Override
    public void convertSave(CompoundTag levelData, File savesDir, String worldDirName, ProgressListener progress) {
        this.savesDir = savesDir;
        this.worldDirName = worldDirName;
        ArrayList<File> dimensionDirs = new ArrayList<File>();
        HashMap<File, ArrayList<File>> dimensionRegionFiles = new HashMap<File, ArrayList<File>>();
        System.out.println("Scanning folders...");
        ISaveFormat fromSaveFormat = SaveFormats.createSaveFormat(this.fromVersion(), savesDir);
        if (fromSaveFormat != null) {
            for (Dimension dimension : Dimension.getDimensionList().values()) {
                dimensionDirs.add(fromSaveFormat.getDimensionRootDir(worldDirName, dimension));
            }
        }
        for (File file : dimensionDirs) {
            dimensionRegionFiles.put(file, this.getRegionFiles(file));
        }
        int totalConversions = 0;
        for (File dimensionDir : dimensionDirs) {
            totalConversions += ((ArrayList)dimensionRegionFiles.get(dimensionDir)).size();
        }
        System.out.println("Total conversion count is " + totalConversions);
        progress.progressStagePercentage(0);
        boolean bl = false;
        int dimId = 0;
        for (File dimensionDir : dimensionDirs) {
            void var9_15;
            var9_15 += this.convertDimensionRegions(Dimension.getDimensionList().get(dimId), (ArrayList)dimensionRegionFiles.get(dimensionDir), (int)var9_15, totalConversions, progress);
            ++dimId;
        }
    }

    abstract int convertDimensionRegions(Dimension var1, ArrayList<File> var2, int var3, int var4, ProgressListener var5);

    ArrayList<File> getRegionFiles(File dimensionDir) {
        ArrayList<File> regionFiles = new ArrayList<File>();
        File[] files = new File(dimensionDir, "region").listFiles();
        if (files != null) {
            regionFiles.addAll(Arrays.asList(files));
        }
        return regionFiles;
    }
}

