/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ByteArrayTag
extends Tag<byte[]> {
    public ByteArrayTag() {
        this(new byte[0]);
    }

    public ByteArrayTag(byte[] array) {
        super(array);
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeInt(((byte[])this.getValue()).length);
        dos.write((byte[])this.getValue());
    }

    @Override
    public void fromJson(@NotNull JsonElement element) throws JsonParseException {
        if (!element.isJsonArray()) {
            throw new JsonParseException("ByteArrayTag json value must be a json array!");
        }
        JsonArray array = element.getAsJsonArray();
        byte[] bytes = new byte[array.size()];
        for (int i = 0; i < bytes.length; ++i) {
            JsonElement e = array.get(i);
            if (!e.isJsonPrimitive()) {
                throw new JsonParseException("ByteArrayTag json value must be a json array values must all be numbers!");
            }
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (!p.isNumber()) {
                throw new JsonParseException("ByteArrayTag json value must be a json array values must all be numbers!");
            }
            bytes[i] = p.getAsByte();
        }
        this.setValue(bytes);
    }

    @Override
    @NotNull
    public JsonElement toJson() {
        byte[] bytes = (byte[])this.getValue();
        JsonArray array = new JsonArray(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            array.add(bytes[i]);
        }
        return array;
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        int length = dis.readInt();
        this.setValue(new byte[length]);
        dis.readFully((byte[])this.getValue());
    }

    @Override
    public byte getId() {
        return Tag.TagID.TAG_BYTE_ARRAY.getId();
    }

    public String toString() {
        if (((byte[])this.getValue()).length > 16) {
            return "\"" + this.getTagName() + "\": [ " + ((byte[])this.getValue()).length + " bytes ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": [ ");
        for (byte b : (byte[])this.getValue()) {
            sb.append(b).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArrayTag)) {
            return false;
        }
        ByteArrayTag otherTag = (ByteArrayTag)obj;
        byte[] thisData = (byte[])this.getValue();
        byte[] otherData = (byte[])otherTag.getValue();
        return Arrays.equals(thisData, otherData);
    }
}

