/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.nbt.tags.ByteArrayTag;
import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.DoubleArrayTag;
import com.mojang.nbt.tags.DoubleTag;
import com.mojang.nbt.tags.FloatTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.LongArrayTag;
import com.mojang.nbt.tags.LongTag;
import com.mojang.nbt.tags.ShortArrayTag;
import com.mojang.nbt.tags.ShortTag;
import com.mojang.nbt.tags.StringTag;
import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CompoundTag
extends Tag<Map<String, Tag<?>>> {
    public CompoundTag() {
        this.setValue(new HashMap());
    }

    public CompoundTag(CompoundTag tag) {
        this.setValue(new HashMap());
        if (tag == null) {
            return;
        }
        for (String key : ((Map)tag.getValue()).keySet()) {
            ((Map)this.getValue()).put(key, tag.getTag(key));
        }
    }

    @Override
    public void write(@NotNull DataOutput dos) throws IOException {
        for (Tag tag : ((Map)this.getValue()).values()) {
            CompoundTag.writeNamedTag(tag, dos);
        }
        dos.writeByte(0);
    }

    @Override
    public void fromJson(@NotNull JsonElement element) throws JsonParseException {
        if (!element.isJsonObject()) {
            throw new JsonParseException("CompoundTag element must be a JsonObject!");
        }
        JsonObject object = element.getAsJsonObject();
        ((Map)this.getValue()).clear();
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            this.put(entry.getKey(), Tag.deserializeFromJson(entry.getValue()));
        }
    }

    @Override
    @NotNull
    public JsonElement toJson() {
        JsonObject out = new JsonObject();
        for (Map.Entry entry : ((Map)this.getValue()).entrySet()) {
            out.add((String)entry.getKey(), Tag.serializeToJson((Tag)entry.getValue()));
        }
        return out;
    }

    @Override
    public void read(@NotNull DataInput dis) throws IOException {
        Tag<?> tag;
        ((Map)this.getValue()).clear();
        while ((tag = CompoundTag.readNamedTag(dis)).getId() != 0) {
            ((Map)this.getValue()).put(tag.getTagName(), tag);
        }
    }

    public boolean containsKey(String key) {
        return ((Map)this.getValue()).containsKey(key);
    }

    public Collection<Tag<?>> getValues() {
        return ((Map)this.getValue()).values();
    }

    @Override
    public byte getId() {
        return Tag.TagID.TAG_COMPOUND.getId();
    }

    public Tag<?> getTagOrDefault(String key, Tag<?> defaultTag) {
        return ((Map)this.getValue()).getOrDefault(key, defaultTag);
    }

    public Tag<?> getTag(String key) {
        return this.getTagOrDefault(key, null);
    }

    public void put(String key, Tag<?> tag) {
        ((Map)this.getValue()).put(key, tag.setName(key));
    }

    public boolean getBoolean(String key) {
        return this.getBooleanOrDefault(key, false);
    }

    public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        return this.getByteOrDefault(key, defaultValue ? (byte)1 : 0) != 0;
    }

    public void putBoolean(String key, boolean value) {
        this.putByte(key, (byte)(value ? 1 : 0));
    }

    public byte getByte(String key) {
        return this.getByteOrDefault(key, (byte)0);
    }

    public byte getByteOrDefault(String key, byte defaultValue) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof ByteTag)) {
            return defaultValue;
        }
        return (Byte)((ByteTag)tag).getValue();
    }

    public void putByte(String key, byte value) {
        this.put(key, new ByteTag(value));
    }

    public short getShort(String key) {
        return this.getShortOrDefault(key, (short)0);
    }

    public short getShortOrDefault(String key, short defaultValue) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof ShortTag)) {
            return defaultValue;
        }
        return (Short)((ShortTag)tag).getValue();
    }

    public void putShort(String key, short value) {
        this.put(key, new ShortTag(value));
    }

    public int getInteger(String key) {
        return this.getIntegerOrDefault(key, 0);
    }

    public int getIntegerOrDefault(String key, int defaultValue) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof IntTag)) {
            return defaultValue;
        }
        return (Integer)((IntTag)tag).getValue();
    }

    public void putInt(String key, int value) {
        this.put(key, new IntTag(value));
    }

    public long getLong(String key) {
        return this.getLongOrDefault(key, 0L);
    }

    public long getLongOrDefault(String key, long defaultValue) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof LongTag)) {
            return defaultValue;
        }
        return (Long)((LongTag)tag).getValue();
    }

    public void putLong(String key, long value) {
        this.put(key, new LongTag(value));
    }

    public float getFloat(String key) {
        return this.getFloatOrDefault(key, 0.0f);
    }

    public float getFloatOrDefault(String key, float defaultValue) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof FloatTag)) {
            return defaultValue;
        }
        return ((Float)((FloatTag)tag).getValue()).floatValue();
    }

    public void putFloat(String key, float value) {
        this.put(key, new FloatTag(value));
    }

    public double getDouble(String key) {
        return this.getDoubleOrDefault(key, 0.0);
    }

    public double getDoubleOrDefault(String key, double defaultValue) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof DoubleTag)) {
            return defaultValue;
        }
        return (Double)((DoubleTag)tag).getValue();
    }

    public void putDouble(String key, double value) {
        this.put(key, new DoubleTag(value));
    }

    public String getString(String key) {
        return this.getStringOrDefault(key, "");
    }

    public String getStringOrDefault(String key, String defaultValue) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof StringTag)) {
            return defaultValue;
        }
        return (String)((StringTag)tag).getValue();
    }

    public void putString(String key, String value) {
        this.put(key, new StringTag(value));
    }

    public byte[] getByteArray(String key) {
        return this.getByteArrayOrDefault(key, new byte[0]);
    }

    public byte[] getByteArrayOrDefault(String key, byte[] defaultArray) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof ByteArrayTag)) {
            return defaultArray;
        }
        return (byte[])((ByteArrayTag)tag).getValue();
    }

    public void putByteArray(String key, byte[] array) {
        this.put(key, new ByteArrayTag(array));
    }

    public short[] getShortArray(String key) {
        return this.getShortArrayOrDefault(key, new short[0]);
    }

    public short[] getShortArrayOrDefault(String key, short[] defaultArray) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof ShortArrayTag)) {
            return defaultArray;
        }
        return (short[])((ShortArrayTag)tag).getValue();
    }

    public void putShortArray(String key, short[] array) {
        this.put(key, new ShortArrayTag(array));
    }

    public double[] getDoubleArray(String key) {
        return this.getDoubleArrayOrDefault(key, new double[0]);
    }

    public double[] getDoubleArrayOrDefault(String key, double[] defaultArray) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof DoubleArrayTag)) {
            return defaultArray;
        }
        return (double[])((DoubleArrayTag)tag).getValue();
    }

    public void putDoubleArray(String key, double[] array) {
        this.put(key, new DoubleArrayTag(array));
    }

    public long[] getLongArray(String key) {
        return this.getLongArrayOrDefault(key, new long[0]);
    }

    public long[] getLongArrayOrDefault(String key, long[] defaultArray) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof LongArrayTag)) {
            return defaultArray;
        }
        return (long[])((LongArrayTag)tag).getValue();
    }

    public void putLongArray(String key, long[] array) {
        this.put(key, new LongArrayTag(array));
    }

    public CompoundTag getCompound(String key) {
        return this.getCompoundOrDefault(key, new CompoundTag());
    }

    public CompoundTag getCompoundOrDefault(String key, CompoundTag defaultCompound) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof CompoundTag)) {
            return defaultCompound;
        }
        return (CompoundTag)tag;
    }

    public void putCompound(String key, CompoundTag compound) {
        this.put(key, compound);
    }

    public ListTag getList(String key) {
        return this.getListOrDefault(key, new ListTag());
    }

    public ListTag getListOrDefault(String key, ListTag defaultList) {
        Tag<?> tag = this.getTagOrDefault(key, null);
        if (!(tag instanceof ListTag)) {
            return defaultList;
        }
        return (ListTag)tag;
    }

    public void putList(String key, ListTag list) {
        this.put(key, list);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": { ");
        for (Tag tag : ((Map)this.getValue()).values()) {
            sb.append(tag.toString()).append("; ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CompoundTag)) {
            return false;
        }
        Map data1 = (Map)this.getValue();
        Map data2 = (Map)((CompoundTag)o).getValue();
        if (data1.size() != data2.size()) {
            return false;
        }
        for (String key : data1.keySet()) {
            Tag<?> value1 = this.getTag(key);
            Tag<?> value2 = ((CompoundTag)o).getTag(key);
            if (!(value1 == null || value2 == null ? value1 != value2 : !value1.equals(value2))) continue;
            return false;
        }
        return true;
    }
}

