/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.DyeColor;

public class ItemBlockPainted<T extends BlockLogic>
extends ItemBlock<T> {
    private final boolean upperMetadata;

    public ItemBlockPainted(Block<T> block, boolean upperMetadata) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.upperMetadata = upperMetadata;
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        if (this.upperMetadata) {
            return super.getKey() + "." + DyeColor.colorFromBlockMeta((int)((itemstack.getMetadata() & 0xF0) >> 4)).colorID;
        }
        return super.getKey() + "." + DyeColor.colorFromBlockMeta((int)(itemstack.getMetadata() & 0xF)).colorID;
    }
}

