/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.item.block.ItemBlockLayer;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;

public abstract class BlockLogicLayerBase
extends BlockLogic {
    public Block<?> fullBlock = null;

    public BlockLogicLayerBase(Block<?> block, Block<?> fullBlock, Material material) {
        super(block, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        block.setBlockItem(() -> new ItemBlockLayer(block));
        this.fullBlock = fullBlock;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 7;
        float f = (float)(2 * (1 + l)) / 16.0f;
        return AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0, f, 1.0);
    }
}

