/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.debug;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class Debug {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean enable = true;
    public static final Profiler baseProfiler;
    public static Profiler currentProfiler;
    private static int fpsCount;
    private static long lastSec;
    private static int fps;

    public static void push(String string) {
        if (!enable) {
            return;
        }
        currentProfiler = currentProfiler.get(string);
        Debug.currentProfiler.startTime = Debug.now();
    }

    public static void change(String string) {
        Debug.pop();
        Debug.push(string);
    }

    public static void reset() {
        if (currentProfiler != baseProfiler) {
            LOGGER.warn("Invalid profiler state: {}", (Object)(currentProfiler != null ? Debug.currentProfiler.name : null));
            currentProfiler = baseProfiler;
        }
        Debug.reset(currentProfiler);
        long now = Debug.now();
        if (Debug.baseProfiler.startTime != -1L) {
            Debug.baseProfiler.time = now - Debug.baseProfiler.startTime;
        }
        Debug.baseProfiler.startTime = now;
        if (lastSec == -1L) {
            lastSec = now;
        }
        if (now > lastSec + 1000000000L) {
            lastSec = now;
            fps = fpsCount;
            fpsCount = 0;
        }
        ++fpsCount;
    }

    private static void reset(Profiler profiler) {
        if (profiler == null) {
            return;
        }
        profiler.time = 0L;
        for (int i = 0; i < profiler.profilers.size(); ++i) {
            Debug.reset(profiler.allProfilers.get(i));
        }
    }

    public static void pop() {
        if (!enable) {
            return;
        }
        if (Debug.currentProfiler.startTime == -1L) {
            throw new IllegalStateException();
        }
        Debug.currentProfiler.time += Debug.now() - Debug.currentProfiler.startTime;
        Debug.currentProfiler.startTime = -1L;
        currentProfiler = Debug.currentProfiler.parent;
        if (currentProfiler == null) {
            throw new NullPointerException();
        }
    }

    static long now() {
        return System.nanoTime();
    }

    public static int getFps() {
        return fps;
    }

    static {
        currentProfiler = baseProfiler = new Profiler("base", null);
        fpsCount = 0;
        lastSec = -1L;
        fps = -1;
    }

    public static class Profiler {
        public final String name;
        public Profiler parent;
        public Map<String, Profiler> profilers = new HashMap<String, Profiler>();
        public List<Profiler> allProfilers = new ArrayList<Profiler>();
        public long startTime = -1L;
        public long time = 0L;

        public Profiler(String name, Profiler parent) {
            this.name = name;
            this.parent = parent;
        }

        protected Profiler get(String name) {
            Profiler profiler = this.profilers.get(name);
            if (profiler == null) {
                profiler = new Profiler(name, this);
                this.profilers.put(name, profiler);
                this.allProfilers.add(profiler);
            }
            return profiler;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

